#!/usr/bin/perl 

############################################
# preldadsport.pl
#
# DESCRIPTION:
# 	Pre- pre-processor for SPoRT data in LDAD.  This script is launched by
#	LDADinfo.txt and simply calls ldadsport.pl and passes it a name of a 
#	file received by LDM.
#
# USE:
#	$ preldadsport.pl <file name (with full path) of the *.gz file>
#
# MODIFICATIONS:
# 20140422:	Code clean-up (Kevin McGrath / NASA SPoRT)
#
# SPoRT CONTACTS:
#	Jason Burks (jason.e.burks@nasa.gov)
#	Kevin McGrath (kevin.m.mcgrath@nasa.gov)
#	Matt Smith (msmith@itsc.uah.edu)
#
############################################

# Logging
#`echo $ARGV[0] > /data/local/preldadsport.txt`;

# Launch ldadsport.pl
system "/awips/fxa/ldad/bin/ldadsport.pl $ARGV[0] &";

print "Exiting preldadsport.pl\n";